using System;
using System.Text;

namespace gov.va.med.vbecs.BOL
{
	#region Header

	///<Package>Package: VBECS - VistA Blood Establishment Computer System</Package>
	///<Warning> WARNING: Per VHA Directive $VADIRECTIVE this class should not be modified</Warning>
	///<MedicalDevice> Medical Device #: $MEDDEVICENO</MedicalDevice>
	///<Developers>
	///	<Developer>Stanislav Antropov</Developer>
	///</Developers>
	///<SiteName>Hines OIFO</SiteName>
	///<CreationDate>2/26/2005</CreationDate>
	///<Note>The Food and Drug Administration classifies this software as a medical device.  As such, it may not be changed in any way. Modifications to this software may result in an adulterated medical device under 21CFR820, the use of which is considered to be a violation of US Federal Statutes.  Acquiring and implementing this software through the Freedom of information Act requires the implementor to assume total responsibility for the software, and become a registered manufacturer of a medical device, subject to FDA regulations</Note>
	///<summary>Convenient builder for constructing broken rules validation messages.</summary>

	#endregion

	public class BrokenRulesMessageBuilder
	{
		private bool _newLineNeeded;
		private StringBuilder _sb;

		///<Developers>
		///	<Developer>Rob Heiberger</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/13/2005</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="6254"> 
		///		<ExpectedInput>Valid Parameters</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="6255"> 
		///		<ExpectedInput>Invalid Parameters</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// Default constructor. Initializes an instance of the class. 
		/// </summary>
		public BrokenRulesMessageBuilder()
		{
			_sb = new StringBuilder();
			_newLineNeeded = false;
		}

		/// <summary>
		/// Adds text to the message. 
		/// </summary>
		/// <param name="stringToAppend">Text to add to the message. Nulls/empty strings are allowed.</param>
		protected virtual void AppendString( string stringToAppend )
		{
			if( IsEmptyString( stringToAppend ) )
				return;
			
			_sb.Append( stringToAppend );
			_newLineNeeded = true;
		}

		/// <summary>
		/// Appends line break to the message.
		/// </summary>
		protected virtual void AppendLineBreak()
		{
			_sb.Append( Environment.NewLine );
			_newLineNeeded = false;
		}

		/// <summary>
		/// Tests if the supplied string is null or empty or consists of spaces only. 
		/// </summary>
		/// <param name="stringToTest">String to test.</param>
		/// <returns>True if supplied string is empty.</returns>
		protected virtual bool IsEmptyString( string stringToTest )
		{
			return stringToTest == null || stringToTest.Trim().Length == 0;
		}

		///<Developers>
		///	<Developer>Rob Heiberger</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/13/2005</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="6256"> 
		///		<ExpectedInput>Valid Parameters</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="6257"> 
		///		<ExpectedInput>Invalid Parameters</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// Appends message to the summary validation message being constructed. 
		/// In essence adds text in a separate line.
		/// </summary>
		/// <param name="brokenRuleMessage">Text to add to the message. Nulls/empty strings are allowed.</param>
		public virtual void AppendMessage( string brokenRuleMessage )
		{
			if( IsEmptyString( brokenRuleMessage ) )
				return;

			if( _newLineNeeded )
				AppendLineBreak();

			_sb.Append( brokenRuleMessage );
			_newLineNeeded = true;
		}

		///<Developers>
		///	<Developer>Rob Heiberger</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/13/2005</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="6262"> 
		///		<ExpectedInput>Valid Parameters</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="6263"> 
		///		<ExpectedInput>Invalid Parameters</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// Returns the summary multiline message constructed with <see cref="AppendMessage"/> calls.
		/// </summary>
		/// <returns>Summary multiline message.</returns>
		public override string ToString()
		{
			return _sb.ToString ();
		}
	}
}
